\
 
; Silicon Chirp 
; one Crazy Cricket, incorporating Freaky Frog and Carrie Canary
; Cricket, Frog and Canary sounds are alternated with S1
; Canary runs daytime, Cricket and Frog at night

#include <pic16f15214.inc>
;#include <xc.inc>   

;configuration bits
CONFIG FEXTOSC=OFF
CONFIG RSTOSC=HFINTOSC_32MHZ
CONFIG CLKOUTEN=OFF
CONFIG VDDAR=HI
CONFIG MCLRE=INTMCLR
CONFIG PWRTS=PWRT_OFF
CONFIG WDTE=01; watchdog selected during sleep only
CONFIG BOREN=OFF
CONFIG BORV=HI
CONFIG PPS1WAY=ON
CONFIG STVREN=OFF
CONFIG BBSIZE=BB64K
CONFIG BBEN=OFF
CONFIG SAFEN=OFF
CONFIG WRTAPP=OFF
CONFIG WRTB=OFF
CONFIG WRTC=OFF
CONFIG WRTSAF=OFF
CONFIG LVP=OFF
CONFIG CP=OFF
    
;define bits
;STATUS flags    
#define C 0
#define Z 2
; FLASH read and write flags
#define NVMREGS 6    
#define RD 0  
#define WR 1
#define FREE 4
#define LWLO 5
#define WREN 2 
    
; initial value
; For MPLAB X IDE Add the line below in the Production/Set project configuration/Customise/pic-as Global Options/Additional Options:
; -Wa,-a -Wl,-pPor_Vec=0h,-pStorage_Vec=F00h
; PSECT = program sections      

PSECT   Storage_Vec,global,class=CODE,delta=2
Storage_Vec:
; sound (Cricket,Frog or Canary) stored in Flash at F00h
DW			03F00H		 ; 3F00=Cricket, 3F01=frog, 3F02=canary    

; RAM 
CRIC_FROG_CAN	equ	020h	; alternate sound flag
STORE1			equ	021h    ; delay counter	
STORE2			equ	022h 	; delay counter
STORE3			equ	023h	; delay counter
ON_FLG			equ	024h	; chirp on flag
TIMER1			equ	025h	; run timer
TIMER2			equ	026h	; run timer
CHECK_COUNT		equ 027h	; counter for LDR checking
SOFT_START		equ	028h	; soft start timer
SOFT_STORE		equ	029h	; store soft start
SOFT_END		equ	02Ah 	; subtraction value
ALTERNATE		equ	02Bh	; frog alternate chirp
TEMP			equ	02Ch	; temporary
FLASH			equ	02Dh	; LED flash
QUIET_TIMER		equ	02Eh	; timer for quieting
QUIET_TIM0		equ	02Fh	; multiplier
QUIET			equ	030h	; quiet flag
TIME			equ	031h	; multiply burst period timer
TIME1			equ	032h	; store for TIME
TIME2			equ	033h	; store for time ending	
VOL_END			equ 034h    ; volume at end
BURST_LOUD		equ 035h	; loud burst length
BURST_SOFT		equ	036h    ; soft level burst length
FREQ_SOFT_END	equ	037h    ; soft frequency at end
FREQ_SOFT		equ	038h	; frequency for soft volume
FREQ_LOUD		equ	039h	; frequency of main tone volume
FREQ_LOUD_END	equ	03Ah	; end frequency
DEL1			equ	03Bh	; delay value counter
VALUE			equ	03Ch    ; internal delay value	
PWM				equ	03Dh    ; pwm drive 	
WIDTH			equ	03Eh	; working pwm duty
WIDTH2			equ	03Fh	; working PWM duty
VOL_MAX			equ	040h	; soft volume
REPEATS			equ 041h    ; number of phrase repeats
TIMER_R			equ	042h    ; delay between repeats
REPEAT_STO		equ	043h	; repeat store
BEGUN   		equ	044h	; started flag 
SYNC_BIRD		equ	045h	; syncronise birds counter timer
TIMER_S			equ	046h	; timer startup 
SW_RUN          equ 047h    ; switch has been pressed flag bit 0
OFFST           equ 048h    ; table lookup offset
CYCLE			equ	049h	; canary cycles
TEMP_C			equ	04Ah	; temporary store for canary sound     
RNDM			equ	04Bh	; counter random
           
; random number generator registers
BARGB0			equ	05Dh	; random number generator
BARGB1			equ	05Eh	; random number generator
BARGB2			equ	05Fh	; random number generator
AARGB0			equ	060h	; random number gen
AARGB1			equ	061h	; random number gen
AARGB2			equ	062h	; random number gen
AARGB3			equ	063h	; random number gen
AARGB4			equ	064h	; random number gen
AARGB5			equ	065h	; random number gen
AARGB6			equ	066h	; random number gen
RANDB0			equ	067h	; random number seed
RANDB1			equ	068h	; random number seed
RANDB2			equ	069h	; random number seed
RANDB3			equ	06Ah	; random number seed
TEMPB0			equ	06Bh	; random gen temp files
TEMPB1			equ	06Ch	; random gen temp files
TEMPB2			equ	06Dh	; random gen temp files
TEMPB3			equ	06Eh	; random gen temp files
LOOPCOUNT		equ	06Fh	; loop counter in random gen

; ******************************************************************
    
; define Power on reset 
     
; Power-On-Reset entry point
        PSECT   Por_Vec,global,class=CODE,delta=2

Por_Vec:
   
	goto	_START	 

 ; **********************************************************
	
; Lookup tables for cricket chirp

GAP:		; gap between individual bursts
	brw		; branch to +w
	retlw	45
	retlw	40		; 40= 18ms
	retlw	41
	retlw	40
	retlw	41
	retlw	39
	retlw	38
	retlw	41
	retlw	40
BURST:
    brw		; branch to +w
	retlw	71		; 70 = 20ms
	retlw	70
	retlw	71
	retlw	70
	retlw	71
	retlw	70
	retlw	73
	retlw	71
	retlw	71
	retlw	70
	retlw	72
	retlw	70
	retlw	70
	retlw	70
	retlw	70
	retlw	70
	retlw	70
SEPARATION:			; separation between the triple burst
	brw		; branch to +w
	retlw	75	
	retlw	71	; 80 = 320ms
	retlw	70
	retlw	72
	retlw	77
	retlw	75	
	retlw	100	
	retlw	80
	retlw	100
	retlw	76
	retlw	77
	retlw	75
	retlw	72	
	retlw	75
	retlw	78
	retlw	75
	retlw	77
	retlw	50
	retlw	60
	retlw	41
	retlw	65
	retlw	71
	retlw	75
	retlw	72
	retlw	73
	retlw	75	
	retlw	70
	retlw	76
	retlw	77
	retlw	76	
	retlw	75
	retlw	70
	retlw	75

; Lookup tables for frog sounds
    
GAP_F:			; gap between individual bursts
	brw		; branch to +w
	retlw	5
	retlw	4		; 4= 1.8ms
	retlw	4
	retlw	4
	retlw	4
	retlw	3
	retlw	3
	retlw	4
	retlw	4
BURST_F:		; individual burst length within triplet
	brw		; branch to +w
	retlw	36		; 35 = 10ms
	retlw	35
	retlw	36
	retlw	35
	retlw	36
	retlw	35
	retlw	37
	retlw	36
	retlw	36
	retlw	35
	retlw	37
	retlw	35
	retlw	35
	retlw	35
	retlw	35
	retlw	35
	retlw	35

SEPARATION_F:	; separation between the triple burst
	brw		; branch to +w
	retlw	100
	retlw	10
	retlw	14
	retlw	12
	retlw	10
	retlw	10
	retlw	14
	retlw	14
	retlw	12
	retlw	10
	retlw	10
	retlw	14
	retlw	12
	retlw	75	
	retlw	71	; 80 ~ 1s
	retlw	70
	retlw	72
	retlw	77
	retlw	75	
	retlw	100	
	retlw	80
	retlw	100
	retlw	76
	retlw	77
	retlw	75
	retlw	72	
	retlw	10
	retlw	10
	retlw	14
	retlw	12
	retlw	50
	retlw	15
	retlw	41

; look up tables for Canary
    
DEL_VARY:	; lookup table for bird sounds
	brw		; branch to +w
	retlw	117
	retlw	117
	retlw	115
	retlw	107
	retlw	118
	retlw	104
	retlw	117
	retlw	116
	retlw	116
	retlw	127
	retlw	117
	retlw	115
	retlw	127
	retlw	117
	retlw	115
	retlw	118
	retlw	117
	retlw	117
	retlw	116
	retlw	115
	retlw	117
	retlw	118
	retlw	104
	retlw	117
	retlw	116
	retlw	116
	retlw	117
	retlw	117
	retlw	120
	retlw	117
	retlw	118
	retlw	114
	retlw	117
	retlw	116
	retlw	116
	retlw	117
	retlw	117
	retlw	115
	retlw	117
	retlw	107
	retlw	115
	retlw	118
	retlw	117
	retlw	115
	retlw	127
	retlw	117
	retlw	115
	retlw	118
	retlw	117
	retlw	117
	retlw	115
	retlw	117
	retlw	118
	retlw	114
	retlw	127
	retlw	116
	retlw	116
	retlw	117
	retlw	117
	retlw	115
	retlw	117
	retlw	117
	retlw	115
	retlw	118
    
RNDM_VARY:	
RNDM_START:
	brw		; branch to +w
    retlw	17
	retlw	19
	retlw	15
	retlw	40
	retlw	22
	retlw	25
	retlw	17
	retlw	16
	retlw	16
	retlw	27
	retlw	17
	retlw	15
	retlw	27
	retlw	17
	retlw	15
	retlw	18
	retlw	17
	retlw	17
	retlw	16
	retlw	15
	retlw	17
	retlw	18
	retlw	43
	retlw	33
	retlw	26
	retlw	36
	retlw	57
	retlw	27
	retlw	17
	retlw	15
	retlw	18
	retlw	17
	retlw	22
	retlw	117
	retlw	120
	retlw	117
	retlw	118
	retlw	44
	retlw	67
	retlw	116
	retlw	116
	retlw	117
	retlw	35
	retlw	117
	retlw	107
	retlw	115
	retlw	118
	retlw	117
	retlw	15
	retlw	17
	retlw	115
	retlw	117
	retlw	118
	retlw	114
	retlw	127
	retlw	116
	retlw	66
	retlw	45
	retlw	54
	retlw	39
	retlw	40
	retlw	34
	retlw	65
	retlw	48
	retlw	55
    
RNDM_RPT:
	brw		; branch to +w
	retlw	5
	retlw	3
	retlw	5
	retlw	4
	retlw	2
	retlw	5
	retlw	7
	retlw	6
	retlw	6
	retlw	7
	retlw	7
	retlw	5
	retlw	7
	retlw	7
	retlw	5
	retlw	8
	retlw	7
	retlw	7
	retlw	6
	retlw	5
	retlw	7
	retlw	8
	retlw	3
	retlw	3
	retlw	6
	retlw	6
	retlw	7
	retlw	17
	retlw	20
	retlw	17
	retlw	18
	retlw	4
	retlw	7
	retlw	16
	retlw	6
	retlw	17
	retlw	22
	retlw	5
	retlw	17
	retlw	7
	retlw	15
	retlw	18
	retlw	17
	retlw	5
	retlw	7
	retlw	7
	retlw	5
	retlw	8
	retlw	7
	retlw	7
	retlw	15
	retlw	17
	retlw	18
	retlw	14
	retlw	20
	retlw	16
	retlw	6
	retlw	5
	retlw	4
	retlw	9
	retlw	2
	retlw	4
	retlw	5
	retlw	8
	retlw	6
    
; ***********************************************************
_START:
; set oscillator calibration
    BANKSEL OSCFRQ
	movlw	00000010B	; oscillator calibration value 4MHz
	movwf	OSCFRQ
	BANKSEL PORTA

; delay to allow device verify after programming
; start up delay ~3s
	movlw	20          ; delay extension
	movwf 	STORE3
DEL_CONT:
	
	movlw	0FFh		; delay routine
	call	DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONT

; set inputs/outputs
	clrf	LATA		; outputs low
	BANKSEL ANSELA
	clrf	ANSELA		; digital I/O
	movlw	00001000B	; pullups off except RA3
    BANKSEL WPUA
	movwf	WPUA
	movlw	00011000B	; outputs/inputs set 
    BANKSEL TRISA
	movwf	TRISA		; port data direction register
    movlw	00011000B	; wdt prescaler/ for 4s timeout) wdt enabled at sleep
    BANKSEL WDTCON
	movwf	WDTCON
	BANKSEL PORTA

; initial conditions
	clrf	LATA
  ; set initial seed value
	movlw	27h			; random seed value
	movwf	RANDB0
	movlw	0F1h
	movwf	RANDB1
	movlw	20h			; random seed value
	movwf	RANDB2
	movlw	49h
	movwf	RANDB3
	call	RAND32			; random number generator
	clrf	ON_FLG			; chirp on flag
	clrf	TIMER1			; run timer
	movlw	90              ; 90 = 90 minutes
	movwf	TIMER2			; run timer
	clrf	ALTERNATE

; set on time period
	movlw	50              ; preset multiplier 
	movwf	QUIET_TIM0
	call	RANDOM			; random number
	movf	AARGB0,w		; random time
	iorlw	00000111B		; sets minimum of 7
	movwf	QUIET_TIMER
	clrf	QUIET			; sound initially on 
  
    clrf    SW_RUN          ; sets flag that switch was pressed
    call    READ            ; read flash
    movwf   CRIC_FROG_CAN   ; sound
 
; check S1 at power up
CK_S1:
    btfsc   PORTA,3
    goto    NO_SW           ; no switch
    bsf     SW_RUN,0        ; switch has been pressed
; switch pressed so increase CRIC_FROG_CAN
    incf    CRIC_FROG_CAN,f
    movf    CRIC_FROG_CAN,w
    sublw   2
    btfss   STATUS,C    
    clrf    CRIC_FROG_CAN   ; clear if 3 or more   
    
; store in Flash
    movf    CRIC_FROG_CAN,w   ; sound
    call    FLASH_WRITE       ; stored 
; flash LEDs to indicate selection        
    call    ACKNOWLEDGE     ; display 1

; delay    
    movlw   5          ; 5 x 100ms = 0.5s
    movwf   TEMP
EXTND0:
    movlw	230          ; delay value 100ms
    call    DELAYX
    decfsz  TEMP,F
    goto    EXTND0
    
    movf    CRIC_FROG_CAN,w
    btfsc   STATUS,Z
    goto    NEW_SND         ; check if new sound to select after 2s delay
    call    ACKNOWLEDGE     ; display 2
; delay    
    movlw   5          ; 5 x 100ms = 0.5s
    movwf   TEMP
EXTND1:
    movlw	230          ; delay value 100ms
    call    DELAYX
    decfsz  TEMP,F
    goto    EXTND1
    
    movf    CRIC_FROG_CAN,w
    xorlw   2    
    btfsc   STATUS,Z
    call    ACKNOWLEDGE     ; display 3
    
NEW_SND:   
; delay    
    movlw   20          ; 20 x 100ms = 2s
    movwf   TEMP
EXTND:
    movlw	230          ; delay value 100ms
    call    DELAYX
    decfsz  TEMP,F
    goto    EXTND
    goto    CK_S1
    
NO_SW:   
    btfss   SW_RUN,0       ; if set bypass the Acknowledge 
; flash LEDs as a power up acknowledgement
   
    call	ACKNOWLEDGE
    
; check for Canary since LDR sense is reversed compared to Cricket and Frog
   movf    CRIC_FROG_CAN,w
   xorlw   2
   btfsc   STATUS,Z
   goto    LDR_CANARY
    
; Cricket and Frog LDR check
; check LDR for light/darkness
CK_LDR:
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	nop
	nop
	nop						; settling time
    nop
    nop
  	btfsc	PORTA,4
	goto	A_SOUND         ; when PORTA is high then darkness
	
STOPX:
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off
	clrf	ON_FLG			; chirp off flag
; run timers reset
	clrf	TIMER1			; run timer
	movlw	90
	movwf	TIMER2			; run timer

; SLEEP, low power mode
       
    movlw	00011001B       ; wdt prescaler/ for 4s timeout)
    BANKSEL WDTCON
	movwf	WDTCON
	sleep					; stop operations
; awakes with watchdog timeout
    movlw	00011000B       ; wdt prescaler/ for 4s timeout)
    movwf	WDTCON
	BANKSEL PORTA
	goto	CK_LDR			; check LDR level
	
A_SOUND:
	bsf		LATA,5			; LDR off
    bsf     LATA,2          ; LEDs off     
; if already started chirping bypass startup delay
	btfsc	ON_FLG,0		; started flag
	goto	STARTED
; flash LEDs
	call	ACKNOWLEDGE		; flash low light detected acknowledgement
	clrf	ALTERNATE

; start up delay ~2.5 -38s random

	movf	AARGB3,w		; random value for delay
	iorlw	00001000B		; ensure minimum delay
	movwf 	STORE3			; delay extension
	movlw	10
	movwf	CHECK_COUNT		; counter to check LDR
	
DEL_CONT1:
	
	movf	CHECK_COUNT,w
	btfsc	STATUS,Z
	goto	LDR_CK
	decf	CHECK_COUNT,f
	goto	DELAY_CONT
LDR_CK:
	movlw	10
	movwf	CHECK_COUNT		; counter to check LDR
; check LDR
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off    
	nop
	nop
    nop
    nop
	nop						; settling time
	btfss	PORTA,4
	goto	STOPX			; when PORTA is high then darkness so continue delay
DELAY_CONT:
	movlw	0FFh 			; delay routine
	call	DELAYX
	decfsz	STORE3,f		; when 0, exit delay
	goto	DEL_CONT1
	bsf		ON_FLG,0		; set on flag 
	goto	CK_LDR			; make sure LDR is still in darkness after delay

STARTED: ; continuation of chirping

; check delays and randomly set chirping on or off during timeout period
	decfsz	QUIET_TIM0,f	; multiplier
	goto	SOUND
	movlw	5               ; different multiplier when off
	btfss	QUIET,0			; on or off flag
	movlw	50              ; preset multiplier
	movwf	QUIET_TIM0
	decfsz	QUIET_TIMER,f	; timer for quieting
	goto	SOUND
	movf	AARGB0,w		; random time
	iorlw	00000111B		; sets minimum of 7
	movwf	QUIET_TIMER
	btfss	QUIET,0			; when bit 0 is set, clear
	goto	SET_QUIET
	bcf		QUIET,0			; sound on
	goto	SOUND

SET_QUIET:
	bsf		QUIET,0			; no sound	
	
SOUND:
 ; check if cricket or frog. Canary tested earlier
	movf	CRIC_FROG_CAN,w
    btfss   STATUS,Z        ; if zero then Cricket
    goto    FROG

;......................................................................
; Cricket sounds
    
CRICKET: 	
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off
	movlw	3               ; burst triplet 
	movwf	STORE3			; 3 x 4kHz bursts per chirp
CHIRP:
	btfsc	QUIET,7			; if quiet required stop LEDs flashing
	goto	Q_LEDS
	btfss	AARGB1,7
	bcf		LATA,2			; LED1 on
	btfsc	AARGB1,7
	bcf		LATA,5			; LED2 on
Q_LEDS:
	movf	AARGB0,w		; random value
	andlw	00001111B		; 16 max
	call	BURST			; get burst length
	movwf	STORE2			; individual burst length
	call	GENERATOR		; 4kHz tone (uses STORE1)

CHIRP_GAP:
	bsf		LATA,2			; LED2 off
	bsf		LATA,5			; LED1 off
	call	RAND32			; random number
	movf	AARGB1,w		; random value
	andlw	00000111B		; 8 max
	call	GAP	
  	call	DELAYX

	decfsz	STORE3,f		; run 3 bursts
	goto	CHIRP

; check LDR
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	nop
	nop
	nop	
    nop
    nop                     ; settling time
	btfss	PORTA,4
	goto 	STOPX

TONE_GAP:
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off

; initial tone gap multiplier to give spacing between the triplets 
	movlw	8
	movwf	STORE3

TONE_GAP1:
	call	RAND32			; random number
	movf	AARGB2,w
	andlw	00011111B		; max of 32
	call	SEPARATION	
    movwf   TEMP
    rlf     TEMP,w
    call	DELAYX			; delay set by separation value
	decfsz	STORE3,f
	goto	TONE_GAP1
	incf	ALTERNATE,f		; alternate

; check timeout timers
CK_TIMEOUT:
; first check for Quiet
	btfss	QUIET,0			; if set then quiet required
	goto	CK_TIMEOUT1
; check if sequence correct
	btfsc	ALTERNATE,0		; start off on correct sequence
	goto	CK_TIMEOUT2	
	bsf		QUIET,7
	goto	CK_TIMEOUT2		; bypass clearing Quiet
CK_TIMEOUT1:

; check if sequence correct
	btfsc	ALTERNATE,0		; stop on correct sequence
	goto	CK_TIMEOUT2
	clrf	QUIET			; clear bit 7
CK_TIMEOUT2:
	decfsz	TIMER1,f
	goto	A_SOUND
	decfsz	TIMER2,f	
	goto	A_SOUND

TIMEOUT_TEST:
; timeout, wait till light returns to reset
; run timers reset
	clrf	TIMER1			; run timer
	movlw	150             ; 150 minutes
	movwf	TIMER2			; run timer
; sleep when dark as timeout. Return to normal run mode when light detected to reset timeout
LDR_TIMEOUT:
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	nop
	nop
	nop
    nop
    nop                     ; settling time
	btfss	PORTA,4			; LDR level

; when low then light so reset and start at normal run mode  
	goto	CK_LDR			; check LDR level

DARK:
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off
	
; SLEEP, low power mode

	movlw	00011001B	; wdt prescaler/ for 4s timeout)
    BANKSEL WDTCON
	movwf	WDTCON
	sleep					; stop operations
; awakes with watchdog timeout
    movlw	00011000B	; wdt prescaler/ for 4s timeout)
    movwf	WDTCON
	BANKSEL PORTA

	goto	LDR_TIMEOUT		; check LDR level	

; ********************************************
; Frog sounds
FROG: ; continuation of Frog 
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	movlw	10
	btfsc	ALTERNATE,0
	movlw	3			; burst modulation 
	movwf	STORE3			; 10 or 3 x 2kHz bursts per chirp
CHIRP_F:
	btfsc	QUIET,7			; if quiet required stop LEDs flashing
	goto	Q_LEDS_F
	btfss	AARGB1,7
	bsf		LATA,5			; LED1 on
	btfsc	AARGB1,7
	bsf		LATA,2			; LED2 on
Q_LEDS_F:
	movf	AARGB0,w		; random value
	andlw	00001111B		; 16 max
	call	BURST_F			; get burst length
	movwf	STORE2			; individual burst length
	bcf		STATUS,C
	rrf		STORE2,f
	call	GENERATOR_F		; frequency tone (uses STORE1)

CHIRP_GAP_F:
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	call	RAND32			; random number
	movf	AARGB1,w		; random value
	andlw	00000111B		; 8 max
	call	GAP_F	
	call	DELAYX
	decfsz	STORE3,f		; run 10 bursts
	goto	CHIRP_F

; check LDR
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	nop
	nop
    nop
    nop
	nop						; settling time
	btfss	PORTA,4
	goto	STOPX			; when PORTA is high then darkness so continue sounding 

TONE_GAP_F:
	bsf		LATA,1			; LDR off
	bcf		LATA,0			; LED2 off
	bcf		LATA,5			; LED1 off

; initial tone gap multiplier to give spacing between the chirp sets 
	movlw	255;40
	movwf	STORE3

TONE_GAP1_F:
	call	RAND32			; random number
	btfss	ALTERNATE,0
	goto	SHORT_F

	movf	AARGB2,w
	andlw	00011111B		; max of 32
	call	SEPARATION_F			
 	call	DELAYX			; delay set by separation value
	decfsz	STORE3,f
	goto	TONE_GAP1_F
	goto	CK_TIMERS_F

SHORT_F:
	movlw	3
	movwf	STORE3
SHORT1_F:
	movf	AARGB1,w		; random value
	andlw	00000111B		; 8 max
	call	BURST_F
	movwf	TEMP
; divide by 2

	bcf		STATUS,C
	rrf		TEMP,w
	
	call	DELAYX
	decfsz	STORE3,f
	goto	SHORT1_F

; check timeout timers
CK_TIMERS_F:
	incf	ALTERNATE,f		; 3 or 10 
	goto	CK_TIMEOUT
     
;.....................................................................    
; CANARY
    
LDR_CANARY:
   	clrf	BEGUN			; started flag
; check LDR
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	nop
	nop
    nop
    nop
	nop						; settling time
	btfss	PORTA,4
	goto	LIGHT			; when PORTA,4 is low then daylight
	
; when PORTA,4 is high then darkness so sleep 
; when low then light  
OFF_CAN:
; SLEEP, low power mode
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off

	movlw	00011001B       ; wdt prescaler/ for 4s timeout)
    BANKSEL WDTCON
	movwf	WDTCON
	sleep					; stop operations
; awakes with watchdog timeout
    movlw	00011000B       ; wdt prescaler/ for 4s timeout)
    movwf	WDTCON
	BANKSEL PORTA

	goto	LDR_CANARY		; check LDR level

LIGHT:
    call    ACKNOWLEDGE
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off

	incf	REPEATS,f
	movf	REPEATS,w
	andlw	00111111B	; 64 max
	call	RNDM_RPT	; lookup table
	movwf	REPEAT_STO	; 2 to 20 repeats

CAN_S:
; check LDR
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	nop
	nop
    nop
    nop
	nop						; settling time
	btfsc	PORTA,4
	goto	OFF_CAN         ; off if dark
 
MEDLEY: ;run differnt canary sounds randomly
    
	incf	REPEATS,f
	movf	REPEATS,w
	andlw	00111111B	; 64 max
	call	RNDM_RPT	; lookup table
	movwf	REPEAT_STO	; 2 to 20 repeats
     
; select canary type
    call    RAND32      ; random numbers
    movf	AARGB4,w
	andlw	00000011B	; 4 max
    btfsc   STATUS,Z    ; if zero
    goto    CAN_FIFE_M
    xorlw   1
    btfsc   STATUS,Z
    goto    CAN_S_M1
    goto    CAN_X_M1

CAN_FIFE_M: ; First canary
	call	FIFE_CANARY
	call	RNDM_TMR
; run repeats
	decfsz	REPEAT_STO,f
	goto	CAN_FIFE_M
	call	RNDM_TMR_EXTRA
    goto    LDR_CANARY
;
    
CAN_X_M1:   ; Second canary
	movf	CYCLE,w
	andlw	00111111B	; 64 max
	call	RNDM_TMR	; lookup table
	movwf	TEMP_C
	btfss	TEMP_C,2
	goto	SEL_CAN_X1M1	
	btfss	TEMP_C,0
	goto	SEL_CAN_X2M1
	btfsc	TEMP_C,0
	call	CANARY_X3
	goto	REP_CAN_XM1
SEL_CAN_X2M1:
	call	CANARY_X2
	goto	REP_CAN_XM1
SEL_CAN_X1M1:
; run repeats
	call	CANARY_X1
REP_CAN_XM1:	
	call	RNDM_TMR
	decfsz	REPEAT_STO,f
	goto	CAN_X_M1
	call	RNDM_TMR_EXTRA
	incf	CYCLE,f		; change chirping
    goto    LDR_CANARY
      
CAN_S_M1:   ; Third canary
	call	CANARY_S
	call	RNDM_TMR
; run repeats
	decfsz	REPEAT_STO,f
	goto	CAN_S_M1
	call	RNDM_TMR_EXTRA
;
	incf	REPEATS,f
	movf	REPEATS,w
	andlw	00111111B	; 64 max
	call	RNDM_RPT	; lookup table
	movwf	REPEAT_STO	; 2 to 20 repeats
CAN_X_M2:
	movf	CYCLE,w
	andlw	00111111B	; 64 max
	call	RNDM_TMR	; lookup table
	movwf	TEMP_C
	btfss	TEMP_C,2
	goto	SEL_CAN_X1M2	
	btfss	TEMP_C,0
	goto	SEL_CAN_X2M2
	btfsc	TEMP_C,0
	call	CANARY_X3
	goto	REP_CAN_XM2
SEL_CAN_X2M2:
	call	CANARY_X2
	goto	REP_CAN_XM2
SEL_CAN_X1M2:
; run repeats
	call	CANARY_X1
REP_CAN_XM2:	
	call	RNDM_TMR
	decfsz	REPEAT_STO,f
	goto	CAN_X_M2
	call	RNDM_TMR_EXTRA
	incf	CYCLE,f		; change chirping
	goto	LDR_CANARY

; random timers 

; REPEATS	; number of phrase repeats
; TIMER_R	; time between repeats
RNDM_TMR:

; run timer_R
	incf	TIMER_R,f
	movf	TIMER_R,w
	andlw	00111111B	; 64 max
	call	RNDM_VARY	; lookup table (17 to 127)
	movwf	STORE3
; divide by 16 for 2.4s to 17s
	bcf		STATUS,C
	rrf		STORE3,f
	bcf		STATUS,C
	rrf		STORE3,f
	bcf		STATUS,C
	rrf		STORE3,f
	bcf		STATUS,C
	rrf		STORE3,f
	incf	STORE3,f	; prevent a 0
	
	btfsc	BEGUN,0	; if started is set bypass checking LDR
	goto	LOOPX_R1
LOOPX_R:
	bcf		LATA,5			; switch on LDR divider
    bcf     LATA,2          ; LEDs off
	nop
	nop
	nop	
    nop
	nop						; settling time
	btfss	PORTA,4			; LDR level
	goto	LOOPX_R1		; when PORTA,4 is low then daylight

; when PORTA,4 is high then darkness so sleep 
; when low then light  

; SLEEP, low power mode
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off
	movlw	1
	movwf	STORE3			; end the timer
	movlw	00010111B   	; wdt prescaler/ for 2s timeout)
    BANKSEL WDTCON
	movwf	WDTCON
	sleep					; stop operations
; awakes with watchdog timeout
    movlw	00011000B       ; wdt prescaler/ for 4s timeout)
    movwf	WDTCON
	BANKSEL PORTA
	goto	LOOPX_R
LOOPX_R1:
; random start delay
	incf	TIMER_S,f
	movf	TIMER_S,w
	andlw	00011111B       ; 32 max

	call	RNDM_START      ; lookup table (17 to 127)
	movwf	SYNC_BIRD

; divide 
	bcf		STATUS,C
	rrf		SYNC_BIRD,f     ; 8 to 64
	bcf		STATUS,C
	rrf		SYNC_BIRD,f     ; 4 to 32
	bcf		STATUS,C
	rrf		SYNC_BIRD,f     ; 2 to 16

LOOP_SYNC:
	movlw	255
	call	DELAYZ          ; 173ms
	decfsz	SYNC_BIRD,f
	goto	LOOP_SYNC

	bsf		BEGUN,0         ; sound running
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off
LOOPX_R11:
						
	movlw	00010111B       ; wdt prescaler/ for 2s timeout)
    BANKSEL WDTCON
	movwf	WDTCON
	sleep					; stop operations
; awakes with watchdog timeout
    movlw	00011000B	; wdt prescaler/ for 4s timeout)
    movwf	WDTCON
	BANKSEL PORTA
	decfsz	STORE3,f
	goto	LOOPX_R11
	bsf		BEGUN,0         ; sound running
	return

RNDM_TMR_EXTRA:

; time between repeats
; 17 to 127 or equivalent to 39s to 4.6m 
	incf	DEL1,f
	movf	DEL1,w
	andlw	00111111B	; 64 max
	call	RNDM_VARY	; lookup table
	movwf	STORE3
; multiply by 2 for 80s to 9minutes
	bcf		STATUS,C
	rlf		STORE3,f
    return

; ...................................................................

FIFE_CANARY:
; WORD1. High level (LOUD)
	
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off
	
	movlw	3               ; burst number 
	movwf	STORE3			; 
	call	CHIRP_W1F
	goto	DEL_FIFE_1

CHIRP_W1F:
	movlw	85
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	12              ; main frequency
	movwf	FREQ_LOUD
	movlw	15              ; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 

; CHIRP_GAP
	movlw	70              ; gap 30ms	
	call	DELAYX

; 2nd burst
	movlw	180             ; burst length 110ms
	movwf	BURST_LOUD		; individual burst length
; set frequency
	movlw	25  			; 2.8kHz
	movwf	FREQ_LOUD
	movlw	25  			; 
	movwf	FREQ_LOUD_END	
	call	GENERATOR_LOUD	; kHz tone (uses STORE1)

	movlw	200 			; gap 90ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W1F
	return

DEL_FIFE_1:
	movlw	100 			; total gap 136ms
	call	DELAYX

; WORD2
W2F:
	movlw	17              ; burst number 
	movwf	STORE3			; 
	call	CHIRP_W2F
	goto	DEL_FIFE2
CHIRP_W2F:

	movlw	70  			; burst length 30ms
	movwf	BURST_LOUD		; individual burst length
; set frequency
	movlw	12  			; 4.5kHz
	movwf	FREQ_LOUD
	movlw	15  			; 
	movwf	FREQ_LOUD_END	
	call	GENERATOR_LOUD		; kHz tone (uses STORE1)

; CHIRP_GAP
	incf	RNDM,f			; counter
	movf	RNDM,w
	andlw	00111111		; 6-bits for 64 max
	movwf	RNDM
	call	DEL_VARY
	movwf	TEMP
	bcf		STATUS,C
	rrf		TEMP,w			; divide by 2 ~ D'65'	; gap 30ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W2F
	return
DEL_FIFE2:
	movlw	146 			; total gap 90ms	
	call	DELAYX

; WORD3

W3F:
	movlw	3               ; burst number 
	movwf	STORE3			; 
CHIRP_W3F:
	movlw	150 			; burst length 65ms
	movwf	BURST_LOUD		; individual burst length
; set frequency
	movlw	12              ; 4.5kHz
	movwf	FREQ_LOUD
	movlw	13  			; 
	movwf	FREQ_LOUD_END	
	call	GENERATOR_LOUD		; kHz tone (uses STORE1)

; CHIRP_GAP
	movlw	220 			; gap 90ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W3F

	movlw	150 			; burst length 65ms
	movwf	BURST_LOUD		; individual burst length
; set frequency
	movlw	12  			; 4.5kHz
	movwf	FREQ_LOUD
	movlw	13  			; 
	movwf	FREQ_LOUD_END	
	call	GENERATOR_LOUD		; kHz tone (uses STORE1)

	movlw	183 			; gap 75ms	
	call	DELAYX

W4F:
	movlw	4   			; burst number 
	movwf	STORE3			; 4 bursts 
CHIRP_W4F:
	movlw	240 			; burst length 165ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	6			; 
	movwf	FREQ_SOFT
	movlw	7			; 
	movwf	FREQ_SOFT_END	
	movlw	5
	movwf	VOL_MAX
	movlw	4
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)

; CHIRP_GAP

	movlw	60 			; gap 65ms	
	call	DELAYX

	decfsz	STORE3,f		; run 4 bursts
	goto	CHIRP_W4F

	movlw	44  			; total gap 85ms	
	call	DELAYX

; word 5
W5F:
	movlw	14  			; burst number 
	movwf	STORE3			; bursts per chirp
CHIRP_W5F:
	movlw	8   			; burst length 32ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	13  			; 4.5kHz
	movwf	FREQ_SOFT
	movlw	15  			; 
	movwf	FREQ_SOFT_END	
	movlw	3
	movwf	VOL_MAX
	movlw	5
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)

; CHIRP_GAP

	movlw	75  			; gap 35ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W5F

; second chirps with altered frequency

	movlw	7               ; burst number 
	movwf	STORE3			; bursts per chirp
CHIRP_W5F2:
	movlw	7               ; burst length 32ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	14              ; 4.5kHz
	movwf	FREQ_SOFT
	movlw	15			; 
	movwf	FREQ_SOFT_END	
	movlw	3
	movwf	VOL_MAX
	movlw	5
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)

; CHIRP_GAP

	movlw	75  			; gap 35ms	
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W5F2
; 130ms delay

	movlw	220			; total gap 130ms	
	call	DELAYX

; word 6
W6F:

	movlw	200
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	15          	; main frequency
	movwf	FREQ_LOUD
	movlw	16  			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 

	movlw	200 			; gap 145ms	
	call	DELAYX
	movlw	140
	call	DELAYX
	
	movlw	9   			; burst number 
	movwf	STORE3			; 
CHIRP_W6F:
	movlw	200
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	15  			; main frequency
	movwf	FREQ_LOUD
	movlw	16  			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 

	movlw	150 			; gap 145ms	
	call	DELAYX
	movlw	100
	call	DELAYX

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W6F

W7F:

	movlw	3   			; burst number 
	movwf	STORE3			; bursts per chirp
CHIRP_W7F:
	
	movlw	90  			; burst length 100ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	9   			; 4.5kHz
	movwf	FREQ_SOFT
	movlw	10  			; 
	movwf	FREQ_SOFT_END	
	movlw	2   
	movwf	VOL_MAX
	movlw	3
	movwf	VOL_END
	call	GENERATOR_SOFT		; kHz tone (uses STORE1)

; CHIRP_GAP

	movlw	220 			; gap 90ms	
	call	DELAYX

	decfsz	STORE3,f		; run 4 bursts
	goto	CHIRP_W7F
	return


CANARY_S:
; run 14 bursts
    
WORD1_SOFT:
	movlw	14              ; burst number 
WORD1_SOFT2:	
	movwf	STORE3			;  2.8kHz bursts per chirp
	call	CHIRP_W12_H
	goto	CHIRP_W12X
	
CHIRP_W12_H:
	movlw	40
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	20              ; main frequency
	movwf	FREQ_LOUD
	movlw	24			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 
; CHIRP_GAP
	movlw	95              ; gap 30ms	
	call	DELAYZ
	decfsz	STORE3,f		; run 
	goto	CHIRP_W12_H
	return
    
CHIRP_W12X:
	
; 1 short burst
	movlw	12
	movwf	BURST_LOUD		; burst length	

; set frequency
	movlw	20  			; main frequency
	movwf	FREQ_LOUD
	movlw	24  			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 

WORD_GAP1:
WORD_GAP_1:
	movlw	18  			; separation 7ms
 	call	DELAYZ			; delay set by separation value

WORD2:; low level
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off
	movlw	14  			; sets of 3 burst number 
	movwf	STORE3			; 14 x 3 x kHz bursts per chirp
CHIRP_W2:
; burst 1 in set of 3
	movlw	5   			; burst length 4ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	25  			; 2.7kHz
	movwf	FREQ_SOFT
	movlw	26  			; 
	movwf	FREQ_SOFT_END	
	movlw	2   
	movwf	VOL_MAX
	movlw	3
	movwf	VOL_END
	call	GENERATOR_SOFT1	; kHz tone (uses STORE1)

	movlw	27  			; gap 11ms	
	call	DELAYZ

; burst 2 in set of 3
	movlw	4   			; burst length 4ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	45  			; 1.5kHz
	movwf	FREQ_SOFT
	movlw	46  			; 
	movwf	FREQ_SOFT_END	
	movlw	2
	movwf	VOL_MAX
	movlw	3
	movwf	VOL_END
	call	GENERATOR_SOFT1	; kHz tone (uses STORE1)

	movlw	27  			; gap 11ms	
	call	DELAYZ

; burst 3 in set of 3
	movlw	9   			; burst length 8ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	42  			; 1.7kHz
	movwf	FREQ_SOFT
	movlw	28  			; 
	movwf	FREQ_SOFT_END	
	movlw	2
	movwf	VOL_MAX
	movlw	3
	movwf	VOL_END
	call	GENERATOR_SOFT1	; kHz tone (uses STORE1)
; CHIRP_GAP
; next 4-lines required when gap between word is < gap
	movf	STORE3,w		; burst counter
	xorlw	1               ; on last burst bypass gap
	btfsc	STATUS,Z
	goto	WORD_GAP2

	movlw	75              ; gap 30ms	
	call	DELAYZ

	decfsz	STORE3,f		; run 14 bursts
	goto	CHIRP_W2

WORD_GAP2:

; initial tone gap multiplier to give spacing between the bursts

WORD_GAP_2:
	movlw	64  			; separation 25ms
 	call	DELAYZ			; delay set by separation value

WORD3: ; 8 bursts 2.7kHz 160ms, 80ms gap, 100ms word separation
	
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off

CHIRP_W3:
	goto	RUN_CANARY

WORD3_CANARY:
	movlw	205
	movwf	BURST_LOUD		; burst length	160ms

; set frequency
	movlw	25              ; main frequency
	movwf	FREQ_LOUD
	movlw	26  			; 
	movwf	FREQ_LOUD_END	; ending frequency
	call	GENERATOR_LOUD	; kHz tone 
	return	

RUN_CANARY:
	call	WORD3_CANARY
	movlw	200 			; gap 80ms	
	call	DELAYZ

;2
	call	WORD3_CANARY
 	movlw	150 			; gap 60ms	
	call	DELAYZ

;3
	call	WORD3_CANARY
	movlw	120 			; gap 50ms	
	call	DELAYZ
; 4-7
	movlw	4   			; burst number 
	movwf	STORE3			; 8 x 2.7kHz bursts per chirp
CHIRP_W3_3:
	call	WORD3_CANARY

	movlw	120 			; gap 50ms	
	call	DELAYZ

	decfsz	STORE3,f		; run bursts
	goto	CHIRP_W3_3
	movlw	80  			; gap 80ms	
	call	DELAYZ
;8
	call	WORD3_CANARY

	movlw	250 			; gap 100ms	
	call	DELAYZ

WORD4: ; 4 bursts 1.96kHz 190ms, 40ms gap 
	bsf		LATA,5			; LDR off
	bsf		LATA,2			; LEDs off
	movlw	4   			; burst number 
	movwf	STORE3			; 4 x 1.9kHz bursts per chirp

CHIRP_W4:
	
	movlw	255 			; burst length 190ms
	movwf	BURST_SOFT		; individual burst length
; set frequency
	movlw	6   			; 
	movwf	FREQ_SOFT
	movlw	7   			; 
	movwf	FREQ_SOFT_END	
	movlw	5
	movwf	VOL_MAX
	movlw	4
	movwf	VOL_END
	call	GENERATOR_SOFT	; kHz tone (uses STORE1)

; CHIRP_GAP
	movlw	100             ; gap 40ms	
	call	DELAYZ

	decfsz	STORE3,f		; run 4 bursts
	goto	CHIRP_W4
    return    

CANARY_X1: ; characteristic electronic chirping

; word 1 CANARY_S.
	incf	REPEATS,f
	movf	REPEATS,w
	andlw	00011111B   	; 32 max
	call	RNDM_VARY       ; lookup table	17-40 for first 32
	movwf	STORE3			; bursts
	call	CHIRP_W12_H
	return
CANARY_X2:
; word 1 FIFE
	incf	REPEATS,f
	movf	REPEATS,w
	andlw	00011111    	; 32 max
	call	RNDM_VARY   	; lookup table
	movwf	STORE3      	; bursts
; DIVIDE BY 4
	bcf		STATUS,C
	rrf		STORE3,f
	bcf		STATUS,C
	rrf		STORE3,f
	call	CHIRP_W1F
	return
CANARY_X3:
; word 2 FIFE	
	incf	REPEATS,f
	movf	REPEATS,w
	andlw	00011111B   	; 32 max
	call	RNDM_VARY       ; lookup table
	movwf	STORE3          ; bursts
	call	CHIRP_W2F
	return

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Generator subroutines

GENERATOR_LOUD:

	clrf	PWM
	
GENERATOR_L:

	movf	PWM,w
	movwf	WIDTH
	movwf	WIDTH2

	movf	FREQ_LOUD,w		; frequency value 
	movwf	STORE1

	movf	PORTA,w
	andlw	11111101B		; clear PORTA
	iorlw	00000001B		; set PORTA
	movwf	LATA

DEC1:

; on for PWM cycles	
	movf	WIDTH,w
	btfsc	STATUS,Z		; when zero clear PORTA
	clrf	PORTA
	decf	WIDTH,f			; decrement width
	decfsz	STORE1,f
	goto	DEC1

	movf	FREQ_LOUD,w		;  frequency value
	movwf	STORE1

	movf	PORTA,w
	andlw	11111110B		; clear PORTA
	iorlw	00000010B		; set PORTA
	movwf	LATA	

DEC2:
; on for PWM cycles	
	movf	WIDTH2,w
	btfsc	STATUS,Z		; when zero clear PORTA
	clrf	PORTA
	decf	WIDTH2,f		; decrement width
	decfsz	STORE1,f
	goto	DEC2
	
	incf	PWM,f

	decfsz	BURST_LOUD,f	; kHz burst length
	goto	GENERATOR_L 
	
; pwm ramp down
	
GENERATOR_LX:
	movf	PWM,w
	movwf	WIDTH
	movwf	WIDTH2

	movf	FREQ_LOUD_END,w	; frequency value 
	movwf	STORE1

	movf	PORTA,w
	andlw	11111101B		; clear PORTA
	iorlw	00000001B		; set PORTA
	movwf	LATA

DEC1X:
; on for PWM cycles	
	movf	WIDTH,w
	btfsc	STATUS,Z		; when zero clear PORTA
	clrf	PORTA
	decf	WIDTH,f			; decrement width
	decfsz	STORE1,f
	goto	DEC1X

	movf	FREQ_LOUD_END,w	;  frequency value
	movwf	STORE1

	movf	PORTA,w
	andlw	11111110B		; clear PORTA
	iorlw	00000010B		; set PORTA
	movwf	LATA	

DEC2X:
; on for PWM cycles	
	movf	WIDTH2,w
	btfsc	STATUS,Z		; when zero clear PORTA
	clrf	PORTA
	decf	WIDTH2,f		; decrement width
	decfsz	STORE1,f
	goto	DEC2X
	
	decfsz	PWM,f			; decrease pulse width
	goto	GENERATOR_LX 
	
	return

; softer drive
GENERATOR_SOFT1:            ; shorter burst
	clrf	PWM
	movlw	1
	movwf	TIME
	movwf	TIME1
	movwf	TIME2
	goto	GENERATOR_S
GENERATOR_SOFT:             ; longer burst
	clrf	PWM
	movlw	6
	movwf	TIME
	movwf	TIME1
	movlw	20
	movwf	TIME2
	
GENERATOR_S:
	movf	PWM,w
	movwf	WIDTH
	movwf	WIDTH2

	movf	FREQ_SOFT,w		; frequency value 
	movwf	STORE1

	movf	PORTA,w
	andlw	11111101B		; clear PORTA
	iorlw	00000001B		; set PORTA
	movwf	LATA

DEC1S:
; on for PWM cycles	
	movf	WIDTH,w
	btfsc	STATUS,Z		; when zero clear PORTA
	clrf	LATA
	decf	WIDTH,f			; decrement width
	decfsz	STORE1,f
	goto	DEC1S

	movf	FREQ_SOFT,w		;  frequency value
	movwf	STORE1

	movf	PORTA,w
	andlw	11111110B		; clear PORTA
	iorlw	00000010B		; set PORTA
	movwf	LATA	

DEC2S:
; on for PWM cycles	
	movf	WIDTH2,w
	btfsc	STATUS,Z		; when zero clear PORTA
	clrf	LATA
	decf	WIDTH2,f		; decrement width
	decfsz	STORE1,f
	goto	DEC2S
	
	incf	PWM,w
	subwf	VOL_MAX,w
	btfsc	STATUS,C
	incf	PWM,f			; increase up to vol_max
	decfsz	TIME,f			; increase period length
	goto	GENERATOR_S
	movf	TIME1,w
	movwf	TIME
	decfsz	BURST_SOFT,f	; kHz burst length
	goto	GENERATOR_S 
	
; pwm ramp down
	movf	VOL_END,w
	movwf	PWM
	movf	TIME2,w	
	movwf	TIME
GENERATOR_SX:
	movf	PWM,w
	movwf	WIDTH
	movwf	WIDTH2

	movf	FREQ_SOFT_END,w	; frequency value 
	movwf	STORE1

	movf	PORTA,w
	andlw	11111101B       ; clear PORTA
	iorlw	00000001B		; set PORTA
	movwf	LATA

DEC1SX:

; on for PWM cycles	
	movf	WIDTH,w
	btfsc	STATUS,Z		; when zero clear PORTA
	clrf	LATA
	decf	WIDTH,f			; decrement width
	decfsz	STORE1,f
	goto	DEC1SX

	movf	FREQ_SOFT_END,w	;  frequency value
	movwf	STORE1

	movf	PORTA,w
	andlw	11111110B		; clear PORTA
	iorlw	00000010B		; set PORTA
	movwf	LATA	

DEC2SX:
	
; on for PWM cycles	
	movf	WIDTH2,w
	btfsc	STATUS,Z		; when zero clear PORTA
	clrf	LATA
	decf	WIDTH2,f		; decrement width
	decfsz	STORE1,f
	goto	DEC2SX

	decfsz	TIME,f			; double period length
	goto	GENERATOR_SX
	movf	TIME2,w	
	movwf	TIME

	decfsz	PWM,f			; decrease pulse width
	goto	GENERATOR_SX 
	
	return
    
; *********************************************
; subroutines

; flash LEDs as acknowledgement
ACKNOWLEDGE:
	movlw	50
	movwf	FLASH
ACK:
	bcf		LATA,2			; LED2
    bsf     LATA,5    
	call	DELAY_FLASH
	bcf		LATA,5
	bsf		LATA,2			; LED1
	call	DELAY_FLASH
	decfsz	FLASH,f         ; 
	goto	ACK
    bsf		LATA,5          ; both LATA2 and LATA5 high so both LEDs off
	return

; 4kHz generator (set STORE2 before routine for burst length)	
GENERATOR:
   	btfsc	QUIET,7			; if set quiet
	goto	SILENT
; divide burst length by 4
	bcf		STATUS,C
	rrf		STORE2,w		; /2
	movwf	SOFT_START		; soft start timer

	bcf		STATUS,C
	rrf		SOFT_START,f	; /4
	bcf		STATUS,C
	rrf		SOFT_START,f	; /8
	movf	SOFT_START,w
	movwf	SOFT_STORE
	subwf	STORE2,w
	movwf	SOFT_END		; soft end timer
	goto	GENERATOR1
GENERATOR2:
	bsf		LATA,0
	bcf		LATA,1
	
	movlw	40              ; frequency value 
	movwf	STORE1
DEC1C:
	decfsz	STORE1,f
	goto	DEC1C	
	bcf		LATA,0
	bsf		LATA,1
	
	movlw	40              ;  frequency value
	movwf	STORE1
DEC2C:
	decfsz	STORE1,f
	goto	DEC2C
	decfsz	SOFT_END,f		; 4kHz burst length
	goto	GENERATOR2
	movf	SOFT_STORE,w
	movwf	SOFT_START
	goto	GENERATOR3

GENERATOR1:
	bsf		LATA,0
	
	movlw	60              ; frequency value 
	movwf	STORE1
DEC5:
	decfsz	STORE1,f
	goto	DEC5	
	bcf		LATA,0
	
	movlw	60              ;  frequency value
	movwf	STORE1
DEC6:
	decfsz	STORE1,f
	goto	DEC6
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR1		; softer burst at half drive
	goto	GENERATOR2		; full burst drive

GENERATOR3:
	bsf		LATA,0
	
	movlw	60              ; frequency value 
	movwf	STORE1
DEC3:
	decfsz	STORE1,f
	goto	DEC3	
	bcf		LATA,0
	
	movlw	60              ;  frequency value
	movwf	STORE1
DEC4:
	decfsz	STORE1,f
	goto	DEC4
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR3		; softer burst at half drive
	return

SILENT:
	
	call	DELAYms			; use delay instead
	return

; frog generator

; frequency generator (set STORE2 before routine for burst length)	
GENERATOR_F:
	btfsc	QUIET,7			; if set quiet
	goto	SILENT
; divide burst length by 4
	bcf		STATUS,C
	rrf		STORE2,w		; /2
	movwf	SOFT_START		; soft start timer
	bcf		STATUS,C
	rrf		SOFT_START,f	; /4
	bcf		STATUS,C
	rrf		SOFT_START,f	; /8
	movf	SOFT_START,w
	movwf	SOFT_STORE
	subwf	STORE2,w
	movwf	SOFT_END		; soft end timer
	goto	GENERATOR1_F
GENERATOR2_F: ; full drive burst
	bsf		LATA,0
	bcf		LATA,1
	
	movlw	100            ; frequency value ;65  
	movwf	STORE1
DEC1_F:
	decfsz	STORE1,f
	goto	DEC1_F	
	bcf		LATA,0
	bsf		LATA,1
	
	movlw	100 			;  frequency value ;65 
	movwf	STORE1
DEC2_F:
	decfsz	STORE1,f
	goto	DEC2_F
	decfsz	SOFT_END,f		; 2kHz burst length
	goto	GENERATOR2_F
	movf	SOFT_STORE,w
	movwf	SOFT_START
	goto	GENERATOR3_F

GENERATOR1_F:
	bsf		LATA,0
	
	movlw	70              ; frequency value ;40
	movwf	STORE1
DEC5_F:
	decfsz	STORE1,f
	goto	DEC5_F	
	bcf		LATA,0
	
	movlw	70              ;  frequency value ;40
	movwf	STORE1
DEC6_F:
	decfsz	STORE1,f
	goto	DEC6_F
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR1_F	; softer burst at half drive
	goto	GENERATOR2_F	; full burst drive

GENERATOR3_F:
	bsf		LATA,0
	
	movlw	70              ; frequency value ;40
	movwf	STORE1
DEC3_F:
	decfsz	STORE1,f
	goto	DEC3_F	
	bcf		LATA,0
	
	movlw	70              ;  frequency value  ;40
	movwf	STORE1
DEC4_F:
	decfsz	STORE1,f
	goto	DEC4_F
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR3_F	; softer burst at half drive
	return

; delay loop 

DELAYms: ; 10ms for D23, 435us/1
	movlw	23          ; delay value
DELAYX:
 	movwf	STORE1		; STORE1 is number of loops value
LOOP8:	
	movlw	117
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9:
	
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY_FLASH: ; 500us
  	movlw	10          ; delay value
	movwf	STORE1		; STORE1 is number of loops value
LOOP10:	
	movlw	11
	movwf	STORE2		; STORE2 is internal loop value	
LOOP11:
	
	decfsz	STORE2,f
	goto	LOOP11
	decfsz	STORE1,f
	goto	LOOP10
	return
    
DELAYZ:
	movwf	STORE1		; STORE1 is number of loops value
	incf	DEL1,w
	movwf	DEL1
	andlw	00011111B	; 32 max
	call	DEL_VARY	; lookup table
	movwf	VALUE	
LOOP8C:	
	movf	VALUE,w		;
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9C:
	
	decfsz	STORE2,f
	goto	LOOP9C
	decfsz	STORE1,f
	goto	LOOP8C
	return
      
; read data memory
READ:	;at end of sequence, 'w' has read data
; This code block will read 1 word of program
; data will be returned in w for ls byte

	BANKSEL NVMADRL 		; Select Bank for NVMCON registers
	clrf 	NVMADRL 		; Store LSB of address
	movlw 	0FH 			; PROG_ADDR_HI ;
	movwf 	NVMADRH 		; Store MSB of address
	bcf 	NVMCON1,NVMREGS ; Do not select Configuration Space
	bsf 	NVMCON1,RD      ; Initiate read
    movf 	NVMDATL,W 		; Get LSB of word
	BANKSEL PORTA           ; bank 0
	return

FLASH_WRITE:

; Initially, erase the row address
    BANKSEL NVMADRL
	movlw	00H
	movwf 	NVMADRL 		; Load lower 8 bits of erase address boundary
	movlw	0FH
	movwf	NVMADRH 		; Load upper 6 bits of erase address boundary
	bcf 	NVMCON1,NVMREGS ; Choose PFM memory area
	bsf		NVMCON1,FREE    ; Specify an erase operation

	call	UNLOCK_SEQ
	bcf		NVMCON1,WREN    ; Disable writes
    
; write routine 
	movlw	0FH
	movwf	NVMADRH 		; Load initial flash address
	movlw	00H
	movwf	NVMADRL
	movlw	000H 			; Load initial low byte data address
	movwf	FSR0L		
	movlw	20H             ; high byte address
	movwf	FSR0H
	bcf		NVMCON1,NVMREGS ; Set Program Flash Memory as write location
	bsf		NVMCON1,WREN    ; Enable writes
	bsf		NVMCON1,LWLO    ; Load only write latches
LOOP:
	moviw	FSR0++
	movwf	NVMDATL 		; Load first data byte
	movlw   03FH            ; 
    movwf	NVMDATH 		; Load second data byte
	
	movf	NVMADRL,W
	xorlw	1H              ; Check if lower bits of address are 00000
	andlw	1H              ; and if on last of 32 addresses
	btfsc	STATUS,Z 		; Last of 32 words?
	goto	START_WRITE 	; If so, go write latches into memory
	call	UNLOCK_SEQ 		; If not, go load latch
	incf	NVMADRL,F 		; Increment address
	goto	LOOP
START_WRITE:
	bcf		NVMCON1,LWLO    ; Latch writes complete, now write memory
    
	call	UNLOCK_SEQ 		; Perform required unlock sequence
	bcf		NVMCON1,WREN    ; Disable writes

	BANKSEL PORTA           ; bank 0
	return

UNLOCK_SEQ:
    bsf		NVMCON1,WREN    ; enable writes
	movlw	55H
	movwf	NVMCON2 		; Begin unlock sequence
	movlw	0AAH
	movwf	NVMCON2
	bsf		NVMCON1,WR
	return

; Random number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	Use:	CALL	RAND32

;	Output:	32 bit random integer in AARGB0, AARGB1, AARGB2, AARGB3

;	Result:	AARG  <--  RAND32( AARG )

;	

;		min	max	mean
;	Timing:	487	487	487	clks



;	Linear congruential random number generator

;		X <- (a * X + c) mod m

;	The calculation is performed exactly, with multiplier a, increment c, and
;	modulus m, selected to achieve high ratings from standard spectral tests.
RANDOM:
RAND32:
		MOVF		RANDB0,W
		MOVWF		AARGB0
		MOVF		RANDB1,W
		MOVWF		AARGB1
		MOVF		RANDB2,W
		MOVWF		AARGB2
		MOVF		RANDB3,W
		MOVWF		AARGB3

		MOVLW		0Dh			; multiplier a = 1664525
		MOVWF		BARGB2
		MOVLW		66h
		MOVWF		BARGB1
		MOVLW		19h
		MOVWF		BARGB0

		CALL		FXM3224U

        INCF        AARGB6,F		; c = 1
        BTFSC       STATUS,Z
        INCF        AARGB5,F
		BTFSC		STATUS,Z
		INCF		AARGB4,F
		BTFSC		STATUS,Z
		INCF		AARGB3,F
		BTFSC       STATUS,Z
        INCF        AARGB2,F
		BTFSC		STATUS,Z
		INCF		AARGB1,F
		BTFSC		STATUS,Z
		INCF		AARGB0,F

		MOVF		AARGB3,W
		MOVWF		RANDB0			; m = 2**32
		MOVF		AARGB4,W
		MOVWF		RANDB1
		MOVF		AARGB5,W
		MOVWF		RANDB2
		MOVF		AARGB6,W
		MOVWF		RANDB3

		RETLW		0

;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clks

;       Min Timing:     11+151 = 162 clks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U:
                CLRF    AARGB4          ; clear partial product
                CLRF    AARGB5
                CLRF    AARGB6
                MOVF  	AARGB0,W
                MOVWF   TEMPB0
                MOVF   	AARGB1,W
                MOVWF   TEMPB1
                MOVF   	AARGB2,W
                MOVWF   TEMPB2
                MOVF   	AARGB3,W
                MOVWF   TEMPB3

                CALL 	UMUL3224L

                RETLW   0

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L:      MOVLW   08
                MOVWF   LOOPCOUNT

LOOPUM3224A:
                RRF     BARGB2,F
                BTFSC   STATUS,C
                GOTO    ALUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224A

                MOVWF   LOOPCOUNT

LOOPUM3224B:
                RRF     BARGB1,F
                BTFSC   STATUS,C
                GOTO    BLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224B

                MOVWF   LOOPCOUNT

LOOPUM3224C:
                RRF     BARGB0,F
                BTFSC   STATUS,C
                GOTO    CLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224C

                CLRF    AARGB0
                CLRF    AARGB1
                CLRF    AARGB2
                CLRF    AARGB3
                RETLW   0
                
ALUM3224NAP:     BCF    STATUS,C
                GOTO    ALUM3224NA
                
BLUM3224NAP:     BCF    STATUS,C
                GOTO    BLUM3224NA
                
CLUM3224NAP:     BCF    STATUS,C
                GOTO    CLUM3224NA

ALOOPUM3224:
                RRF     BARGB2,F
                BTFSS   STATUS,C
                GOTO    ALUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

ALUM3224NA:
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                DECFSZ  LOOPCOUNT,F
                GOTO    ALOOPUM3224

                MOVLW   8
                MOVWF   LOOPCOUNT

BLOOPUM3224:
                RRF     BARGB1,F
                BTFSS   STATUS,C
                GOTO    BLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

BLUM3224NA:
                RRF    	AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                DECFSZ  LOOPCOUNT,F
                GOTO    BLOOPUM3224

                MOVLW   8
                MOVWF   LOOPCOUNT

CLOOPUM3224:
                RRF     BARGB0,F
                BTFSS   STATUS,C
                GOTO    CLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

CLUM3224NA:
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                RRF     AARGB6,F
                DECFSZ  LOOPCOUNT,F
                GOTO    CLOOPUM3224
				RETURN	
                

	end _START
